/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep;

import com.singularsys.jep.Evaluator;
import com.singularsys.jep.FunctionTable;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.NodeFactory;
import com.singularsys.jep.NumberFactory;
import com.singularsys.jep.OperatorTable;
import com.singularsys.jep.Parser;
import com.singularsys.jep.PrintVisitor;
import com.singularsys.jep.VariableFactory;
import com.singularsys.jep.VariableTable;

public class ComponentSet {
    protected NumberFactory numFac;
    protected VariableFactory varFac;
    protected NodeFactory nodeFac;
    protected VariableTable varTab;
    protected FunctionTable funTab;
    protected OperatorTable opTab;
    protected Parser parser;
    protected Evaluator evaluator;
    protected PrintVisitor pv;

    public ComponentSet() {
    }

    public ComponentSet(Jep jep) {
        this.numFac = jep.getNumberFactory();
        this.varFac = jep.getVariableFactory();
        this.nodeFac = jep.getNodeFactory();
        this.varTab = jep.getVariableTable();
        this.funTab = jep.getFunctionTable();
        this.opTab = jep.getOperatorTable();
        this.parser = jep.getParser();
        this.evaluator = jep.getEvaluator();
        this.pv = jep.getPrintVisitor();
    }

    public JepComponent[] getComponents() {
        return new JepComponent[]{this.numFac, this.varFac, this.nodeFac, this.varTab, this.funTab, this.opTab, this.parser, this.evaluator, this.pv};
    }

    public NumberFactory getNumberFactory() {
        return this.numFac;
    }

    public NodeFactory getNodeFactory() {
        return this.nodeFac;
    }

    public VariableFactory getVariableFactory() {
        return this.varFac;
    }

    public VariableTable getVariableTable() {
        return this.varTab;
    }

    public FunctionTable getFunctionTable() {
        return this.funTab;
    }

    public OperatorTable getOperatorTable() {
        return this.opTab;
    }

    public Parser getParser() {
        return this.parser;
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public PrintVisitor getPrintVisitor() {
        return this.pv;
    }

    public void setNodeFactory(NodeFactory nodeFactory) {
        this.nodeFac = nodeFactory;
    }

    public void setNumberFactory(NumberFactory numberFactory) {
        this.numFac = numberFactory;
    }

    public void setVariableFactory(VariableFactory variableFactory) {
        this.varFac = variableFactory;
    }

    public void setFunctionTable(FunctionTable functionTable) {
        this.funTab = functionTable;
    }

    public void setVariableTable(VariableTable variableTable) {
        this.varTab = variableTable;
    }

    public void setOperatorTable(OperatorTable operatorTable) {
        this.opTab = operatorTable;
    }

    public void setEvaluator(Evaluator evaluator) {
        this.evaluator = evaluator;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    public void setPrintVisitor(PrintVisitor printVisitor) {
        this.pv = printVisitor;
    }
}

